IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_SCA_Localidades') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_SCA_Localidades 
END
GO

CREATE PROCEDURE [dbo].[CPJ_SCA_Localidades] @pJsonRecibido VARCHAR(MAX)
AS 

SET NOCOUNT ON


IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_SCA_Localidades_') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN 
	EXEC CPJ_SCA_Localidades_ @pJsonRecibido
	RETURN
END	





DECLARE	@pSoc_Nro			VARCHAR(20),
		@pDoc_Nro			VARCHAR(20),
	    @pPasap_Nro			VARCHAR(50),
	    @pTag				VARCHAR(30),
		@pQR				VARCHAR(200),
		@pCateg				VARCHAR(5000),
		@pId_Campeonato		VARCHAR(5000),
	    @pFecha				VARCHAR(30),
	    @pInc_Socios		TINYINT,
	    @pMeses_Deuda		INT

SET @pSoc_Nro				= ISNULL(CONVERT(VARCHAR(20), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Soc_Nro')),'')
SET @pDoc_Nro				= ISNULL(CONVERT(VARCHAR(20), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Doc_Nro')),'')
SET @pPasap_Nro				= ISNULL(CONVERT(VARCHAR(50), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Pasap_Nro')),'')
SET @pTag					= ISNULL(CONVERT(VARCHAR(30), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'Tag')),'')
SET @pQR			        = ISNULL(CONVERT(VARCHAR(200), 	dbo.CF_JSON_VALUE(@pJsonRecibido,'QR')), '')
SET @pCateg			        = ISNULL(CONVERT(VARCHAR(5000), dbo.CF_JSON_VALUE(@pJsonRecibido,'Categ')), '')
SET @pId_Campeonato		    = ISNULL(CONVERT(VARCHAR(5000), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Campeonato')), '')
SET @pFecha					= ISNULL(CONVERT(VARCHAR(30),	dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')), '')
SET @pInc_Socios			= ISNULL(CONVERT(TINYINT,		dbo.CF_JSON_VALUE(@pJsonRecibido,'Inc_Socios')), 0)
SET @pMeses_Deuda			= ISNULL(CONVERT(INT,			dbo.CF_JSON_VALUE(@pJsonRecibido,'Meses_Deuda')), 0)



DECLARE @Fecha_ST  VARCHAR(30)

SET @Fecha_ST = SUBSTRING(@pFecha,7,4) + SUBSTRING(@pFecha,4,2) + SUBSTRING(@pFecha,1,2) +' '+ RIGHT(@pFecha,8)
--PRINT @Fecha_ST


UPDATE xParametros SET Valor_Date = @Fecha_ST WHERE IdParametro = 'SCA_Ecsa_Fecha'
UPDATE xParametros SET Valor_Integer = CONVERT(INT,@pId_Campeonato) WHERE IdParametro = 'SCA_Ecsa_Camp'
UPDATE xParametros SET Valor_Integer = CONVERT(INT,@pMeses_Deuda) WHERE IdParametro = 'SCA_Ecsa_Deud'
UPDATE xParametros SET Valor_String = @pCateg WHERE IdParametro = 'SCA_Ecsa_Categ'


DECLARE @Sql VARCHAR(MAX)

CREATE TABLE #Resp (
		id_persona int
		,socio_nro	varchar(14)
		,nombre	varchar(300)
        ,doc_nro bigint
        ,pasap_nro varchar(50)
		,tag varchar(30)
        ,qr varchar(100)
		,credencial_banda varchar(100)
		,ult_cuota_paga varchar(10)
		,id_categoria int
		,categoria varchar(100)
		,activo tinyint
		,id_ubicacion varchar(14)
		,ubicacion varchar(300)
		,id_sector int
		,sector varchar(100)
		,id_entrada_tipo int
		,entrada_tipo varchar(100)
		)


SET @Sql = 'INSERT INTO #Resp
	SELECT	CL.Id_Cliente AS Id_Persona
		,LTRIM(RTRIM(ISNULL(CL.Id_Cliente_Externo, ''''))) AS Socio_Nro
		,LTRIM(RTRIM(ISNULL(CL.Razon_Social, ''''))) AS Nombre 
        ,ISNULL(CL.Doc_Nro, 0) AS Doc_Nro
        ,ISNULL(CL.Pasap_Nro, 0) AS Pasap_Nro
		,LTRIM(RTRIM(ISNULL(CL.Credencial_Nro, ''''))) AS Tag
        ,CONVERT(VARCHAR(100), ISNULL(CL.Doc_Nro, 0)) AS QR
		,LTRIM(RTRIM(ISNULL(CL.Credencial_Banda1, ''''))) AS Credencial_Banda
		,CONVERT(VARCHAR(10), (ISNULL(CL.Ult_Cuota_Paga, ''19000101'')),102) AS Ult_Cuota_Paga
		,ISNULL(CL.Id_Tipo_Cli, 0) AS Id_Categoria
		,LTRIM(RTRIM(ISNULL(CT.Descripcion, ''''))) AS Categoria
		,ISNULL(CL.Activo, 0) AS Activo
		,CI.Id_Producto AS Id_Ubicacion
		,ISNULL(PR.Descripcion_Detallada, '''') AS Ubicacion 
		,PR.Id_Sector
		,S.Descripcion AS Sector
		,CB.Id_Lista AS Id_Entrada_Tipo
		,PLP.Descripcion AS Entrada_Tipo
	FROM	Cbtes CB, Cbtes_Items CI, Clientes CL
			, Productos PR LEFT JOIN Empresas_Sedes_Sectores S ON PR.Id_Sector = S.Id_Sector
			, Prod_Listas_Precios PLP, Clientes_Tipos CT
			, Cbtes_Tipos CBT
	WHERE	CB.Id_Trans = CI.Id_Trans 
			AND CI.Id_Cliente = CL.Id_Cliente 
			AND CI.Id_Producto = PR.Id_Producto 
			AND CB.Id_Lista = PLP.Id_Lista_Precio 
			AND CL.Id_Tipo_Cli = CT.Id_Tipo_Cli 
			AND CB.Id_Estado_Cbte <> 3 
			AND PR.Tipo = ''L'' 
			AND CBT.Id_Tipo_Cbte = CB.Id_Tipo_Cbte
			AND ( 
					(CBT.Compromete_Pedido = 1 AND CB.Id_Estado_Cbte <> 3 )
				OR 
					(CBT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte = 2 )
				)
			AND CL.Id_Cliente > 1 
			AND PR.Activo = 1 
			AND CI.Fecha_QA <= '''+ @Fecha_ST +'''	
			AND CI.Fecha_Venc >= '''+ + @Fecha_ST +'''	
			AND CL.Id_Tipo_Cli IN ('+ @pCateg +')
			AND PLP.Id_Evento_Grupo IN ('+ @pId_Campeonato +')'

IF @pCateg != ''
	SET @Sql += ' AND CL.Id_Tipo_Cli IN (' + @pCateg + ')'


IF @pSoc_Nro != ''
	SET @Sql += ' AND CL.Id_Cliente_Externo =''' + @pSoc_Nro + ''''

IF @pPasap_Nro != ''
	SET @Sql += ' AND CL.Pasap_Nro = '''+ @pPasap_Nro +''''
	
	
IF @pQR != '' 
	IF ISNUMERIC(@pQR) = 1
		SET @Sql += ' AND CL.Doc_Nro = '+ @pQR
	ELSE
		SET @Sql += ' AND 1 = 0 '         --si paso un dato alfa no muestro evito error

	

IF @pDoc_Nro != '' 
	IF ISNUMERIC(@pDoc_Nro) = 1
		SET @Sql += ' AND CL.Doc_Nro = '+ @pDoc_Nro
	ELSE
		SET @Sql += ' AND 1 = 0 '         --si paso un dato alfa no muestro evito error


IF @pPasap_Nro != ''
	SET @Sql += ' AND CL.Pasap_Nro = '''+ @pPasap_Nro +''''

IF @pTag != ''
	SET @Sql += ' AND CL.Credencial_Nro = '''+ @pTag +''''



SET @Sql += ' ORDER BY PR.Id_Sector,CI.Id_Producto'

EXEC (@Sql)



IF @pInc_Socios = 1
BEGIN
	CREATE TABLE #Resp_Soc(
        Id_Persona INT
        ,Socio_Nro	VARCHAR(14)
		,Nombre	VARCHAR(300)
		,Id_Tipo_Doc VARCHAR(5)
        ,Doc_Nro BIGINT
        ,Pasap_Nro VARCHAR(50)
  		,Tag VARCHAR(30)
        ,QR VARCHAR(100)
        ,Credencial_Banda VARCHAR(100)
		,Id_Categoria INT
		,Categoria VARCHAR(100)
		,Ult_Cuota_Paga VARCHAR(10)
	)
	INSERT INTO #Resp_Soc
	EXEC CPJ_SCA_Clientes_Export @pJsonRecibido
	
	CREATE INDEX z_RespLoc ON #Resp (Id_Persona)
	
	INSERT INTO #Resp 
	          (Id_Persona,Socio_Nro,Nombre,Doc_Nro,Pasap_Nro,Tag,QR,Credencial_Banda
	          ,Id_Categoria,Categoria,Ult_Cuota_Paga,Id_Entrada_Tipo,Entrada_Tipo
	          ,Activo,Id_Ubicacion,Ubicacion,Id_Sector,Sector)
		SELECT Id_Persona,Socio_Nro,Nombre,Doc_Nro,Pasap_Nro,Tag,QR,Credencial_Banda
			,Id_Categoria,Categoria,Ult_Cuota_Paga,0,'Socio' 
			,1,'','',0,''
		FROM #Resp_Soc R2
		WHERE NOT EXISTS (SELECT 1 FROM #Resp R3 WHERE R3.Id_Persona = R2.Id_Persona)
	

END
SELECT * FROM #Resp




/*


EXEC CPJ_SCA_Localidades '{"Categ":"1,2,3,4,5,6,7,8,9,10,11,12"
							,"Id_Campeonato","3"
							,"Fecha":"18-05-2023T21:30:00" 
							,"Inc_Socios":"1"
							,"Meses_Deuda":"2"
							}'
EXEC CPJ_SCA_Localidades '{"Categ":"6"
							,"Id_Campeonato","3"
							,"Fecha":"18-05-2023T21:30:00" 
							,"Inc_Socios":"1"
							,"Meses_Deuda":"2"
							}'

							
EXEC CPJ_SCA_Localidades '{"Categ":"1"
							,"Id_Campeonato","3"
							,"Fecha":"18-05-2023T21:30:00" 
							,"Inc_Socios":"1"
							,"Meses_Deuda":"2"
							}'							

EXEC CPJ_SCA_Localidades '{"Categ":"1,2,3,4,5,6,7,8,9,10,11,12"
							,"Id_Campeonato","3"
							,"Fecha":"18-05-2023T21:30:00" 
							,"Inc_Socios":"1"
							,"QR":"22858993"
							}'



*/

